	function [wc, ws, wi2] = BS_2_LP_SPEC(ws1, wc1, wc2, ws2)
 
	%	Computes the band edges used in the geometric symmetric
	%	LP-to-BS transformation
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
		
	% 	Authors: 			Oscar Gustafsson and Per Lwenborg, 2004-09-09
	% 	Modified by: 	 	
	%	Copyright:			by authors - not released for commercial use
	% 	Version:			1 
	% 	Known bugs:	 
	% 	Report bugs to:		Wanhammar@gmail.com
	%
	
	if(wc1>ws1 | ws1>ws2 | ws2>wc2)
		error('Improper order of the frequencies. Must be Wc1<Ws1<Ws2<Wc2.')
	else
		wi2 = wc1*wc2;
		if(wi2 ~= ws1*ws2)
			if(wi2 > ws1*ws2)
				ws2 = wi2/ws1;
			else
				ws1 = wi2/ws2;
			end
		end
		wc = wi2/(wc2-wc1);
		ws = wi2/(ws2-ws1);
	end
